-------------------------------------
--17.06.2005 (AG/LEO)
--    (  )  
--08.02.2006 (Supraden)
--    TurnBase . 
--         TurnBase .
--07.03.2006 (AG)
--   ,  ,  ,  .
--09.03.2006 (AG)
--  
--  proxy
--      
--15.03.2006 (AG)
--   
--   ,      15 -     -       
--        (     -      ) -            
--    -      0.5 -       
-------------------------------------

ConstantsXLS =
{
	BP_PER_AP_ANIM_EFFORT	= 100*0.4,
	AP_MAXIMUM		= 25,
	MAX_AP_CARRIED		= 5,

	BP_PER_AP_NO_EFFORT	= 200,
	BP_PER_AP_MIN_EFFORT	= 100,
	BP_PER_AP_LT_EFFORT	= 50,
}

fighter_tb =
{
	onCombatStarted = function(id)
		sendMessage("combat_started", NEW_ENTRY)
		WAS_TB = 1
		RT_COMMENT_SAID = 0

		local stopAll = function(index,value)
			if(value.id~=id) then
				if(not service.isPlayer(value.id)) then
					stop(value.id)
				end
				memory.clearLastSeen(value.id)
				Humans[value.id].leaderTurnsForSkip = 0
				Humans[value.id].surroundTurnsForSkip = 0
				Humans[value.id].turnDone = false
			end
		end

		table.foreach(Humans,stopAll)
		Humans[id].leaderTurnsForSkip = 0
		Humans[id].surroundTurnsForSkip = 0
		Humans[id].turnDone = false
		memory.clearLastSeen(id)
	end,

	onCombatFinished = function(id)
		Sectors[CUR_MISSION.Name].onKill()
		WAS_TB = 0
		if (RT_COMMENT_SAID == 0) then
			sendMessage("combat_ended", NEW_ENTRY)
			local rnd = math.random(4)
			local merc = getRandomMerc()
			RT_COMMENT_SAID = 1
			local remark = "_sector_clear_0"
			if (service.isThereEnemy(id)) then
				remark = "_enemy_in_rt_0"
			end
			service.showAck(merc, merc..remark..rnd, 1)
		end
	end,

	lastTurnTeam = NONE,
	teamTurns = {},
	breathAtEndTurn = {},
	apAtEndTurn = {},

	refreshBreath =  function( id )
		local teamID = team(id)	
       		local processUnit = function(index,value)
       			if(team(value.id)~=teamID) then
				fighter_tb.breathAtEndTurn[value.id] = getPersonParameter(value.id,"BREATH")
			end
		end
		table.foreach(Humans,processUnit)
	end,

	getWeightModifier = function( id )
		local ret = 1.0
		local bNow = getPersonParameter(id,"BREATH")
		local bWas = fighter_tb.breathAtEndTurn[id]
		local aWas = fighter_tb.apAtEndTurn[id]
		if(isValid(bWas) and isValid(aWas) and (bNow~=bWas)) then
			ret = ConstantsXLS.BP_PER_AP_ANIM_EFFORT / (bNow-bWas) * (ConstantsXLS.AP_MAXIMUM - aWas + ConstantsXLS.MAX_AP_CARRIED)
		end
		return(ret)
	end,

	calcTrueBreathChange = function( id )
		local bNow = getPersonParameter(id,"BREATH")
		local aWas = fighter_tb.apAtEndTurn[id]
		local bWas = fighter_tb.breathAtEndTurn[id]
		if(isValid(bWas) and isValid(aWas) and (bNow~=bWas)) then
			local sBPCost = 0
			if(aWas>ConstantsXLS.MAX_AP_CARRIED) then
				local sUnusedAPs = aWas - ConstantsXLS.MAX_AP_CARRIED;
				local sBreathPerAP = ConstantsXLS.BP_PER_AP_NO_EFFORT;
				sBreathPerAP = sBreathPerAP / fighter_tb.getWeightModifier( id );
				sBPCost = (ConstantsXLS.AP_MAXIMUM - sUnusedAPs) * sBreathPerAP;
			end
			fighter_tb.deductPoints(id,sBPCost,bWas)
		end
	end,
	
	deductPoints = function(id,sBPCost,bWas)
		if(bWas==nil) then
			bWas = getPersonParameter(id, "BREATH")
		end
		local sBreathFactor = 100 + (100 - bWas/100);
		local bLifeMax = getPersonParameter(id, "DURABILITYMAX")
		local bLife = getPersonParameter(id, "HEALTH")
		local ubBandaged = getPersonParameter(id, "BANDAGED")
		local bStrength = getPersonParameter(id, "STRENGTH")
		sBreathFactor = sBreathFactor + 100 * (bLifeMax - (bLife + ubBandaged/2)) / bLifeMax
log("breath","sBreathFactor",sBreathFactor,sBPCost)
		if( bStrength > 80 ) then
			sBreathFactor = sBreathFactor - (bStrength - 80)/2
		end
		if( sBreathFactor == 0 ) then
			sBPCost = 0
		else
	   		sBPCost = ((sBPCost * 100) / sBreathFactor);
		end
		log(id,"Breath was:",bWas,"Breath regeneration:",sBPCost)
		bWas =  bWas+sBPCost
		if(bWas>10000) then
			bWas = 10000
		elseif(bWas<0) then
			bWas = 0
		end
		setPersonParameter(id,"BREATH",bWas)
	end,

	onStartTurn = function(prevTeamID,turnTeamID)
		if(prevTeamID == NONE) then
			fighter_tb.teamTurns = {}
			fighter_tb.breathAtEndTurn = {}
			fighter_tb.apAtEndTurn = {}
		else
			local turn = fighter_tb.teamTurns[prevTeamID]
			if(turn==nil) then
				turn = 0
			end
			fighter_tb.teamTurns[prevTeamID] = turn + 1
			if(prevTeamID == PLAYER) then
                      		local processMerc = function(index,value)
                      			memory.resortLastSeen(value)
				end
				table.foreach(CUR_MISSION.Mercs,processMerc)
                        end
                        
			local processUnits = function(index,value)
				if(team(value.id)==turnTeamID) then
					fighter_tb.calcTrueBreathChange(value.id)
				elseif(team(value.id)==prevTeamID) then
                                    	fighter_tb.apAtEndTurn[value.id] = takeAP(value.id)
				end
			end
			table.foreach(Humans,processUnits)
		end
	end,

	getTurn = function(id)
		local teamID = team(id)
		local turn = fighter_tb.teamTurns[teamID]
		if(turn==nil) then
			turn = 0
		end
		return(turn)
	end,

	think = function(id, time)
calls.enter("fighter_tb.think",id)

		if (WAS_TB == 0) then
			fighter_tb.onCombatStarted(id)
		end

               	fighter_tb.refreshBreath(id)

		local teamID = team(id)
		if(fighter_tb.lastTurnTeam~=teamID) then
			fighter_tb.onStartTurn(fighter_tb.lastTurnTeam,teamID)
			fighter_tb.lastTurnTeam = teamID
		end

		Humans[id].blasted = false
		service.updateVisible(id)

		if(service.isPlayer(id)) then
			if(not healthOK(id)) then
				setPersonParameter(id, "BREATH", 0)
				setPersonParameter(id, "AP", 0)
			end
calls.leave("fighter_tb.think",id)
			return
		end

		local APcost = 0
		local currentAP = takeAP(id)
		if (Humans[id].busy == 2) then
			log(id, "  .    ", Humans[id].strategy)
			Humans[id].busy = 0
			Humans[id].priority = 0
		end
		if(currentAP <= 0) then
			log(id, " AP")
			endOfTurn(id)
calls.leave("fighter_tb.think",id)
			return
		end

		if(Humans[id].busy == 1) then 
			APcost = getAPcost(id)
			if(APcost < 0) then
				Humans[id].freeze = Humans[id].freeze + 1
				log(id, "   .", Humans[id].freeze)
				Humans[id].turnDone = false
				Humans[id].busy = 0
				Humans[id].priority = 0
				Humans[id].going_behind = false
				if (Humans[id].strategy > getAIConst().maxStrategy) then
					log(id,"**** max strategy, freezed, clear")
					Humans[id].known = NONE
					Humans[id].check = NONE
					Humans[id].last_strafe = NONE
					Humans[id].moveonly = false
					if(Humans[id].freeze>3) then
						Humans[id].retreat = false
						Humans[id].surrounded = false
						Humans[id].surroundTurnsForSkip = 0
					end
				end
				clearAllOrders(id)
calls.leave("fighter_tb.think",id)
				return
			elseif(APcost <= currentAP) then
				log(id, " AP. Cost:", APcost, "AP:", currentAP)
				if(Humans[id].attacked and isUnitValid(Humans[id].current_target)) then
					service.remarksMgr(id, Humans[id].attack_type, Humans[id].current_target)
				end
				if(Humans[id].attack_type == "GRENADE") then
					if(isUnitValid(Humans[id].blasted_target) and
						isValid(Humans[Humans[id].blasted_target])) then
						Humans[Humans[id].blasted_target].blasted = true
					end
					Humans[id].blasted_target = NONE
				end
				executeOrders(id)
				Humans[id].busy = 2
calls.leave("fighter_tb.think",id)
				return
			elseif(APcost > currentAP) then
				log(id, "  AP. :", currentAP, ":", APcost)
				if(Humans[id].moveonly and (currentAP > 4)) then
					log(id, " .   ")
					executeOrders(id)									--  
					Humans[id].busy = 2										--   -    
calls.leave("fighter_tb.think",id)
					return
				else
					log(id, " AP  4   .   .")
					Humans[id].turnDone = false
					Humans[id].busy = 0										--   -    
					Humans[id].priority = 0
					clearAllOrders(id)
calls.leave("fighter_tb.think",id)
					return
				end
			end
		else
			if(Humans[id].turnDone or (Humans[id].strategy > getAIConst().maxStrategy)) then
				log(id, " .  AP: "..currentAP)
				Humans[id].moveonly = false
				Humans[id].last_strafe = NONE
				endOfTurn(id)
calls.leave("fighter_tb.think",id)
				return
			end

			clearAllOrders(id)

			log(id, " ")
			local health = getPersonParameter(id, "HEALTH")
			log(id, "  = ", health)
			log(id, "My energy = ", getPersonParameter(id, "BREATH"))

			if(not healthOK(id)) then
				setPersonParameter(id, "BREATH", 0)
				log(id, "       ")
				if(addPose(id,"lie")) then
					Humans[id].busy = 1
					estimateAP(id)
				else
					endOfTurn(id)
				end
calls.leave("fighter_tb.think",id)
				return
			end

			if(Humans[id].lastMoveCommand~=nil) then
				addSmartMove(id, Humans[id].lastMoveCommand.mode, 
					Humans[id].lastMoveCommand.x, Humans[id].lastMoveCommand.y, 
					Humans[id].lastMoveCommand.z, Humans[id].lastMoveCommand.f)
				Humans[id].lastMoveCommand = nil
				Humans[id].moveonly = true
			else
				local result = 0
				if(not service.isCivilian(id)) then 
					result = b_soldier.tb_think(id, Humans[id].strategy, time)
				else
					result = b_civilian.tb_think(id, Humans[id].strategy, time)
				end
				if(result == 0) then
					log(id, " ")
					if(not disappeared(id)) then
						endOfTurn(id)
					end
calls.leave("fighter_tb.think",id)
					return
				elseif(result == 2) then
					Humans[id].busy = 0
					log(id, "SKIP")
calls.leave("fighter_tb.think",id)
					return
				end
				Humans[id].strategy = Humans[id].strategy + 1
				log(id, "  ",Humans[id].strategy)
			end
			Humans[id].busy = 1
			estimateAP(id)
calls.leave("fighter_tb.think",id)
			return
		end
	end,

	enemySighted = function(id, enemy)
calls.enter("fighter_tb.enemySighted",id)
		log(id," :", enemy)
		if(not IsAlive(enemy)) then
			log(id, " -  ")
			fighter_tb.corpseSighted(id, enemy)
calls.leave("fighter_tb.enemySighted",id)
			return
		end
		if(not healthOK(enemy)) then
			log(id, "   ")
calls.leave("fighter_tb.enemySighted",id)
			return
		end
		if(service.isPlayer(id)) then
			if((not service.checkIfVisible(id, enemy)) and healthOK(id)) then
				stop(id)
				local count = tostring(math.random(4))
				local commented = false
				log(id,"** esize",Humans[id].visible_enemies.size)
				if(Humans[id].visible_enemies.size > 3) then
					commented = service.showAck(id, id.."_too_many_enemies_0"..count, 0.5, 1, 1)
				end
				if(not commented) then
					service.showAck(id, id.."_enemy_sighted_0"..count, 1, 1, 1)
				end
			end
		else
			Humans[id].status = "RED"
			if(not (Humans[id].attacked and (Humans[id].attack_type == "GRENADE"))) then
				stop(id)
			end
			if (memory.removeKnownEnemy(id, enemy)) then
				fighter_tb.enemySightedAgain(id, enemy)
			end		
		end
		service.addToVisible(id, enemy)
calls.leave("fighter_tb.enemySighted",id)
	end,

	enemySightedAgain = function(id, enemy)
calls.enter("fighter_tb.enemySightedAgain",id)
		log(id, "     ")
calls.leave("fighter_tb.enemySightedAgain",id)
	end,

	enemyHided = function(id, enemy)
calls.enter("fighter_tb.enemyHided",id)
		if(not canOneSeeOther(id, enemy)) then
			log(id, "   :", enemy)
			service.removeFromVisibleL(id, enemy)
			if(IsAlive(enemy)) then
				if(not service.isPlayer(id)) then
					memory.addKnownEnemy(id, enemy, time())
					Humans[enemy].reportedby = NONE
				end
			end
		end
calls.leave("fighter_tb.enemyHided",id)
	end,

	neutralSighted = function(id, person)
calls.enter("fighter_tb.neutralSighted",id)
		if(not IsAlive(person)) then
			fighter_tb.corpseSighted(id, person)
		elseif((not service.isPlayer(id)) and service.isHateThem(id, person)) then
			log(id, "NEUTRAL SIGHTED AND I HATE HIM OR HIS TEAM - PUTTING ON VISIBLE ENEMIES LIST", person)
			service.addToVisible(id, person)
			Humans[id].status = "RED"
		end
calls.leave("fighter_tb.neutralSighted",id)
	end,

	neutralHided = function(id, person)
calls.enter("fighter_tb.neutralHided",id)
		if((not service.isPlayer(id)) and IsAlive(person)) then
			if(service.checkIfVisible(id, person, true)) then
				log(id, "NEUTRAL HIDED AND HE IS ON VISIBLE ENEMIES LIST", person)
				memory.addKnownEnemy(id, person, time())
			else
				service.removeFromVisibleL(id, person)
			end
		end
calls.leave("fighter_tb.neutralHided",id)
	end,

	allySighted = function(id, person)
calls.enter("fighter_tb.allySighted",id)
-- not called directly?
		if(not IsAlive(person)) then
			fighter_tb.corpseSighted(id, person)
		end
calls.leave("fighter_tb.allySighted",id)
	end,

	allyHided = function(id, person)
calls.enter("fighter_tb.allyHided",id)
-- not called directly?
calls.leave("fighter_tb.allyHided",id)
	end,

	teammateSighted = function(id, person)
calls.enter("fighter_tb.teammateSighted",id)
		if(not IsAlive(person)) then
			fighter_tb.corpseSighted(id, person)
		end
calls.leave("fighter_tb.teammateSighted",id)
	end,

	teammateHided = function(id, person)
calls.enter("fighter_tb.teammateHided",id)
calls.leave("fighter_tb.teammateHided",id)
	end,
	
	corpseSighted = function(id, person)
-- not called directly?
calls.enter("fighter_tb.corpseSighted",id)
		if(service.checkIfVisible(id, person, true)) then
			service.removeFromVisibleG(id, person)
		end
		if((relations(team(id),team(person))==ALLY)) then
			if(not KnownDead[person]) then
				Humans[id].status = "RED"
				local moraleMod = getAIConst().mpAllyCorpseSighted
				if(service.isPlayer(id)) then
					moraleMod = MoralePenalty.SMALL
				end
				updateMorale(id, moraleMod, "DEAD TEAMMATE FOUND")
			end
		end
		KnownDead[person] = true
calls.leave("fighter_tb.corpseSighted",id)
	end,

	sound = function(id, stype, x, y, z, owner, time)
calls.enter("fighter_tb.sound",id..","..stype..","..owner)
		if(service.isPlayer(id)) then
			if(math.random() > 0.6) then
				local dist = service.person2point_distance(id, x, y, z)
				local count = math.random(4)
				local unknown = ((not isGameInRT()) or (math.random()>0.9))
				if(isUnitValid(owner) and
					(service.checkIfVisible(id, owner, true) or 
					(relations(team(id),team(owner)) ~= ENEMY))) then
					unknown = false
				end
				if((stype == "bullet") and (dist < 2)) then
					service.showAck(id, id.."_underfire_0"..count, 1, 1, 1)
				elseif((stype == "step") and unknown) then
					service.showAck(id, id.."_heard_0"..count, 1, 1, 1)
				end
			end
		else
			service.processSoundEvent(id, stype, x, y, z, owner, time)
		end
calls.leave("fighter_tb.sound",id..","..stype..","..owner)
	end,

	splash = function(id, type, power)
calls.enter("fighter_tb.splash",id)
-- not called directly?
calls.leave("fighter_tb.splash",id)
	end,

	hurted = function(id, x, y, z, owner_id)
calls.enter("fighter_tb.hurted",id..","..owner_id)
	        b_soldier.applyBreathPenalty(id)
		service.checkPlayerUnits(team(id))
		if(not service.isPlayer(id)) then
			trigger_service.hurt_observer.addHurt(id, owner_id)
			service.processHurtEvent(id, x, y, z, owner_id)
		end
calls.leave("fighter_tb.hurted",id..","..owner_id)
	end,

	teammateHurted = function(id, person)
calls.enter("fighter_tb.teammateHurted",id)
-- not called directly?
		updateMorale(id, -1, "TEAMMATE HURT")
calls.leave("fighter_tb.teammateHurted",id)
	end,

	teammateDown = function(id, person)
calls.enter("fighter_tb.teammateDown",id)
-- not called directly?
		updateMorale(id, -5, "TEAMMATE DOWN")
calls.leave("fighter_tb.teammateDown",id)
	end,

	stunned = function(id)
calls.enter("fighter_tb.stunned",id)
-- not called directly?
calls.leave("fighter_tb.stunned",id)
	end,

	unstunned = function(id)
calls.enter("fighter_tb.unstunned",id)
-- not called directly?
calls.leave("fighter_tb.unstunned",id)
	end,

	blinded = function(id)
calls.enter("fighter_tb.blinded",id)
-- not called directly?
calls.leave("fighter_tb.blinded",id)
	end,

	unblinded = function(id)
calls.enter("fighter_tb.unblinded",id)
-- not called directly?
calls.leave("fighter_tb.unblinded",id)
	end, 

	onTrigger = function(id, msg, trigger_name)
calls.enter("fighter_tb.onTrigger",id)
-- not called directly?
calls.leave("fighter_tb.onTrigger",id)
	end, 

	ordersChanged = function(id, current_priority)
calls.enter("fighter_tb.ordersChanged",id)
		if(not service.isPlayer(id)) then
	                Humans[id].orders = Humans[id].orders+1
		end
calls.leave("fighter_tb.ordersChanged",id)
	end, 

	waitPresent = function(id, set)
calls.enter("fighter_tb.waitPresent",id)
-- not called directly?
calls.leave("fighter_tb.waitPresent",id)
	end, 

	offenderPresent	= function(id, enemy)
calls.enter("fighter_tb.offenderPresent",id)
-- not called directly?
calls.leave("fighter_tb.offenderPresent",id)
	end, 
	
	rememberSounds = function(id)
calls.enter("fighter_tb.rememberSounds",id)
-- not called directly?
calls.leave("fighter_tb.rememberSounds",id)
	end, 

	shoutOffender = function(id, enemy)
calls.enter("fighter_tb.shoutOffender",id)
-- not called directly?
calls.leave("fighter_tb.shoutOffender",id)
	end,
	
	updateKnownEnemyList = function(id, from_id, enemy_list)
calls.enter("fighter_tb.updateKnownEnemyList",id)
		log(id,"updateKnownEnemyList from", from_id)
		local update_list = function(name, visible_by_from_id)
			if((name ~= "size") and 
				visible_by_from_id and
				(not Humans[id].visible_enemies[name])) then
				memory.addKnownEnemy(id, name, time())
			end
		end
		table.foreach(enemy_list, update_list)
calls.leave("fighter_tb.updateKnownEnemyList",id)	
	end,
	
	-------------------------------------------------
	--    
	commonAlarm = function(id, atype, from_id)
calls.enter("fighter_tb.commonAlarm",id)
-- not called directly?
		log(id,"Common Alarm ",atype," from ",from_id)
calls.leave("fighter_tb.commonAlarm",id)
	end,
	
	-------------------------------------------------
	--    
	localAlarm = function(id, atype, from_id)
calls.enter("fighter_tb.localAlarm",id)
-- not called directly?
		log(id,"Local Alarm ",atype," from ",from_id)
calls.leave("fighter_tb.localAlarm",id)
	end,
	
	-------------------------------------------------
	--        
	reportVisibleEnemyListToOther = function(id, rel)
calls.enter("fighter_tb.reportVisibleEnemyListToOther",id)	
-- not called directly?
		local enemy_list=deepcopy(Humans[id].visible_enemies)
		local list=service.getHumanList(id,rel,false)
		
		local send_update = function(index,value)
			if(value~=id) then
				fighter_tb.updateKnownEnemyList(value, id, enemy_list)
			end
		end
		
		table.foreach(list,send_update)
calls.leave("fighter_tb.reportVisibleEnemyListToOther",id)
	end,
	
	-------------------------------------------------
	--   
	-- type = {wound, sound, corpse}
	giveCommonAlarm = function(id, types, rel)
calls.enter("fighter_tb.giveCommonAlarm",id)		
-- not called directly?
		local list = service.getHumanList(id,rel,false)
		
		local give_alarm = function(index,value)
			fighter_tb.commonAlarm(value,types,id)
		end
		
		table.foreach(list,give_alarm)
calls.leave("fighter_tb.giveCommonAlarm",id)
	end,
		
	-------------------------------------------------
	--   
	-- type = {wound, sound, corpse}
	giveLocalAlarm = function(id, atype, rel, range)
calls.enter("fighter_tb.giveLocalAlarm",id)		
-- not called directly?
		local list = service.getHumanListInRange(id,rel,false,range)
	
		local give_alarm = function(index,value)
			fighter_tb.localAlarm(value,atype,id)
		end
		
		table.foreach(list,give_alarm)
calls.leave("fighter_tb.giveLocalAlarm",id)
	end,
}
